<?php

$hudson_edge_options = hudson_edge_return_global_options();
$hudson_edge_page_id							= hudson_edge_get_page_id();
$hudson_edge_content_bottom_area 				= "yes";
$hudson_edge_content_bottom_area_sidebar 		= "";
$hudson_edge_content_bottom_area_in_grid 		= true;
$hudson_edge_content_bottom_background_color 	= '';

//is content bottom area enabled for current page?
if(get_post_meta($hudson_edge_page_id, "edgt_enable_content_bottom_area", true) != ""){
	$hudson_edge_content_bottom_area = get_post_meta($hudson_edge_page_id, "edgt_enable_content_bottom_area", true);
} elseif(isset($hudson_edge_options['enable_content_bottom_area'])) {
	//content bottom area is turned on in theme options
	$hudson_edge_content_bottom_area = $hudson_edge_options['enable_content_bottom_area'];
}

//is content bottom area enabled?
if($hudson_edge_content_bottom_area == 'yes') {
	//is sidebar chosen for content bottom area for current page?
	if(get_post_meta($hudson_edge_page_id, 'edgt_choose_content_bottom_sidebar', true) != ""){
		$hudson_edge_content_bottom_area_sidebar = get_post_meta($hudson_edge_page_id, 'edgt_choose_content_bottom_sidebar', true);
	} elseif(isset($hudson_edge_options['content_bottom_sidebar_custom_display'])) {
		//sidebar is chosen for content bottom area in theme options
		$hudson_edge_content_bottom_area_sidebar = $hudson_edge_options['content_bottom_sidebar_custom_display'];
	}

	//take content bottom area in grid option for current page if set or from theme options otherwise
	if(get_post_meta($hudson_edge_page_id, 'edgt_content_bottom_sidebar_in_grid', true) != ""){
		$hudson_edge_content_bottom_area_in_grid = get_post_meta($hudson_edge_page_id, 'edgt_content_bottom_sidebar_in_grid', true);
	} elseif(isset($hudson_edge_options['content_bottom_in_grid'])) {
		$hudson_edge_content_bottom_area_in_grid = $hudson_edge_options['content_bottom_in_grid'];
	}

	//is background color for content bottom area set for current page
	if(get_post_meta($hudson_edge_page_id, "edgt_content_bottom_background_color", true) != ""){
		$hudson_edge_content_bottom_background_color = 'background-color: '.esc_attr(get_post_meta($hudson_edge_page_id, "edgt_content_bottom_background_color", true));
	}
}
?>
<?php if($hudson_edge_content_bottom_area == "yes") { ?>

	<div class="content_bottom" <?php hudson_edge_inline_style($hudson_edge_content_bottom_background_color); ?>>
		<?php if($hudson_edge_content_bottom_area_in_grid == 'yes' && is_active_sidebar($hudson_edge_content_bottom_area_sidebar)){ ?>
		<div class="container">
			<div class="container_inner clearfix">
				<?php } ?>
				<?php dynamic_sidebar($hudson_edge_content_bottom_area_sidebar); ?>
				<?php if($hudson_edge_content_bottom_area_in_grid == 'yes'){ ?>
			</div>
		</div>
	<?php } ?>
	</div>
<?php } ?>